using gov.va.med.vbecs.Common;
using System;
using System.Linq;

namespace gov.va.med.vbecs.BOL
{
    /// <summary>
    /// PendingSpecimenTasModel
    /// </summary>
    public class PendingSpecimenTasModel : PendingTestModel, IPendingSpecimenTestModel
    {
        /// <summary>
        /// PatientSpecimenGuid
        /// </summary>
        public Guid PatientSpecimenGuid { get; set; }
        /// <summary>
        /// SpecimenUid
        /// </summary>
        public string SpecimenUid { get; set; }
        /// <summary>
        /// PatientOrder
        /// </summary>
        public OrderedTest OrderedTest { get; set; }
        /// <summary>
        /// SpecimenResultSetGuid
        /// </summary>
        public Guid ResultSetGuid { get; set; }
        /// <summary>
        /// SpecimenExpirationDate
        /// </summary>
        public DateTime? SpecimenExpirationDate { get; set; }
        /// <summary>
        /// CprsOrderNumber
        /// </summary>
        public string CprsOrderNumber { get; set; } 
        /// <summary>
        /// PendingSpecimenAboRhModel
        /// </summary>
        public PendingSpecimenAboRhModel PendingSpecimenAboRhModel { get; set; }
        /// <summary>
        /// PendingSpecimenAbsModel
        /// </summary>
        public PendingSpecimenAbsModel PendingSpecimenAbsModel { get; set; }
        /// <summary>
        /// InterpText
        /// </summary>
        public override string InterpText
        {
            get
            {
                throw new NotImplementedException("InterpText should be gotten from either PendingSpecimenAboRhModel or PendingSpecimenAbsModel objects in this class");
            }
        }
        /// <summary>
        /// WorkloadProcessID
        /// </summary>
        public override WorkloadProcessID WorkloadProcessId
        {
            get
            {
                return WorkloadProcessID.Unknown;
            }
        }
        /// <summary>
        /// Should only be called on individual abo/rh or abs objects
        /// </summary>
        public TestValidationModel Validate()
        {
            return null;
        }
    }
}



